#pragma once

#include <Windows.h>
#include <si.h>
#include <siapp.h>

extern "C" {

	/// <summary>
	/// 3D豸
	/// </summary>
	__declspec(dllimport) typedef struct
	{
		/// <summary>
		/// 豸
		/// </summary>
		int id;

		/// <summary>
		/// 3D豸
		/// </summary>
		SiHdl device;

		/// <summary>
		/// 3DϢ
		/// </summary>
		int WM_3DMOUSE;

	} ThreeDDeviceData;

	/// <summary>
	/// 3D
	/// </summary>
	__declspec(dllimport) typedef struct
	{
		/// <summary>
		/// ֵΪ1ʱɹȡ3D
		/// </summary>
		long result;

		/// <summary>
		/// TX ֵ
		/// </summary>
		long tx;

		/// <summary>
		/// TY ֵ
		/// </summary>
		long ty;

		/// <summary>
		/// TZ ֵ
		/// </summary>
		long tz;

		/// <summary>
		/// RX ֵ
		/// </summary>
		long rx;

		/// <summary>
		/// RY ֵ
		/// </summary>
		long ry;

		/// <summary>
		/// RZ ֵ
		/// </summary>
		long rz;

		/// <summary>
		/// ¼
		/// </summary>
		long si_event;

	} ThreeDMouseData;

	/// <summary>
	/// 豸Ϣ
	/// </summary>
	ThreeDDeviceData* device_datas[20];

	/// <summary>
	/// ȫֳʼ3D
	/// </summary>
	__declspec(dllimport) void three_mouse_global_init();

	/// <summary>
	/// ȫ3D
	/// </summary>
	__declspec(dllimport) void three_mouse_global_dispose();

	/// <summary>
	/// ȡ3D
	/// </summary>
	/// <returns>3D</returns>
	__declspec(dllimport) int three_mouse_get_device_number();

	/// <summary>
	/// 3D豸
	/// </summary>
	/// <param name="hWnd">ھ</param>
	/// <param name="id"></param>
	/// <returns>3D</returns>
	__declspec(dllimport) ThreeDDeviceData* three_mouse_open_device(HWND hWnd, int id);

	/// <summary>
	/// 3DϢ
	/// </summary>
	/// <param name="id">豸</param>
	/// <param name="wParam">Ϣ</param>
	/// <param name="lParam">Ϣ</param>
	/// <returns>3D</returns>
	__declspec(dllimport) ThreeDMouseData* three_mouse_on_message(int id, WPARAM wParam, LPARAM lParam);

	/// <summary>
	/// 3Dָ
	/// </summary>
	/// <param name="ptr">ָ</param>
	__declspec(dllimport) void three_mouse_dispose_ptr(void* ptr);
}